#include "AudioStack/SMT/clSrcState_RampDownToOff.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{


void clSrcState_RampDownToOff::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{
   if (NULL != pclAudioSource)
   {
      // invoke command on MW-interface
      pclAudioSource->vMW_Off(pclAudioSource->u8GetNextSource());
   }
}

void clSrcState_RampDownToOff::vMsg_OffDone(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateOff(), u32UserData);
}

void clSrcState_RampDownToOff::vMsg_Pause(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

void clSrcState_RampDownToOff::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

void clSrcState_RampDownToOff::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // set manually to off because the off-done was lost in undervoltage
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff() , u32UserData);
}

}

